SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- TABLE Rules Modification
-- April 2012 
-- =============================================

-- =============================================
-- New Rules.Deleted field 
-- April 2012 
-- =============================================

IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'Deleted' AND object_id = OBJECT_ID(N'Rules'))
BEGIN
	ALTER TABLE Rules ADD Deleted bit default(0) NOT NULL
END
GO

-- =============================================
-- New Rules.Id field as an Identity and the NEW Primary Key
-- April 2012 
-- =============================================

IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'Id' AND object_id = OBJECT_ID(N'Rules'))
BEGIN
	ALTER TABLE Rules ADD Id int IDENTITY (1 , 1) NOT NULL
END
GO
-----------------------------------------------------------------------
-- MODIFY RULES TABLE, DROP THE ACTUAL PRIMARY KEY TO CREATE A NEW ONE
-- April 2012 
-----------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.all_objects AS o 
	INNER JOIN sys.tables AS t ON t.[object_id]=o.[parent_object_id]
	WHERE o.[type]='PK' AND o.[name]='PK_Rules')
	
	ALTER TABLE Rules DROP CONSTRAINT PK_Rules
GO

ALTER TABLE Rules ADD CONSTRAINT PK_Rules PRIMARY KEY (Id)
GO




-- =============================================
-- TABLE ExtendedRules Modification
-- April 2012 
-- =============================================

-- =============================================
-- New ExtendedRules.Deleted field 
-- April 2012 
-- =============================================

IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'Deleted' AND object_id = OBJECT_ID(N'ExtendedRules'))
BEGIN
	ALTER TABLE ExtendedRules ADD Deleted bit default(0) NOT NULL
END
GO
-- =============================================
-- New ExtendedRules.Id field as an Identity and the NEW Primary Key
-- April 2012 
-- =============================================

IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'Id' AND object_id = OBJECT_ID(N'ExtendedRules'))
BEGIN
	ALTER TABLE ExtendedRules ADD Id int IDENTITY (1 , 1) NOT NULL
END
GO
-----------------------------------------------------------------------
-- MODIFY RULES TABLE, DROP THE ACTUAL PRIMARY KEY TO CREATE A NEW ONE
-- April 2012 
-----------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.all_objects AS o 
	INNER JOIN sys.tables AS t ON t.[object_id]=o.[parent_object_id]
	WHERE o.[type]='PK' AND o.[name]='PK_ExtendedRules')
	
	ALTER TABLE ExtendedRules DROP CONSTRAINT PK_ExtendedRules
GO

ALTER TABLE ExtendedRules ADD CONSTRAINT PK_ExtendedRules PRIMARY KEY (Id)
GO






-- =============================================
-- TABLE Historic Modification
-- April 2012 
-- =============================================

-- =============================================
-- New Historic.RuleId field 
-- March 2012 
-- =============================================

IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'RuleId' AND object_id = OBJECT_ID(N'Historic'))
BEGIN
	ALTER TABLE Historic ADD RuleId int NULL
END
GO

-- =============================================
-- New Historic.ExtRuleId field 
-- March 2012 
-- =============================================

IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'ExtRuleId' AND object_id = OBJECT_ID(N'Historic'))
BEGIN
	ALTER TABLE Historic ADD ExtRuleId int NULL
END
GO

-- =============================================
-- New Historic.NextCallBack field 
-- March 2012 
-- =============================================

IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'NextCallBack' AND object_id = OBJECT_ID(N'Historic'))
BEGIN
	ALTER TABLE Historic ADD NextCallBack DateTime NULL
END
GO





IF exists (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[Sp_updaterespondenthistory]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [dbo].[Sp_updaterespondenthistory]
GO

/****** Object:  StoredProcedure [dbo].[Sp_updaterespondenthistory]    Script Date: 03/07/2012 15:33:16 ******/
CREATE PROCEDURE [dbo].[Sp_updaterespondenthistory]
                @ProjectId           INT,
                @CollectMode         INT,
                @HisRespondent       VARCHAR(10),
                @HisCallNumber       INT,
                @HisInterviewer      VARCHAR(10),
                @HisResult           VARCHAR(2),
                @HisCallDate         DATETIME,
                @HisTimeSlot         INT,
                @HisCallDuration     INT,
                @HisDataType         INT,
                @HisStartQuestion    VARCHAR(10),
                @HisEndQuestion      VARCHAR(10),
                @HisMonitoring       BIT,
                @HisDialerLine       INT,
                @HisWait             INT,
                @HisPause            INT,
                @HisFileReference    VARCHAR(120),
                @HisPreviousCallDate DATETIME,
                @HisLifeState        VARCHAR(2),
                @HisPhone            VARCHAR(20) = NULL,
                @DialingMode         INT = NULL, -- Null => Do not change
                @LevelChanged        BIT = 0,
                @Notes               NVARCHAR(MAX) = NULL,
                @RuleId              INT = NULL,
                @ExtRuleId           INT = NULL,
                @NextCBKDate         DATETIME = NULL
AS
  UPDATE historic
  SET    hisrespondent = @HisRespondent,
         hiscallnumber = @HisCallNumber,
         hisinterviewer = @HisInterviewer,
         hisresult = @HisResult,
         hiscalldate = @HisCallDate,
         histimeslot = @HisTimeSlot,
         hiscallduration = @HisCallDuration,
         hisdatatype = @HisDataType,
         hisstartquestion = @HisStartQuestion,
         hisendquestion = @HisEndQuestion,
         hismonitoring = @HisMonitoring,
         hisdialerline = @HisDialerLine,
         hiswait = @HisWait,
         hispause = @HisPause,
         hisfilereference = @HisFileReference,
         hispreviouscalldate = @HisPreviousCallDate,
         hislifestate = @HisLifeState,
         projectid = @projectId,
         collectmode = @collectMode,
         HisPhone = @HisPhone,
         DialingMode = IsNull(@DialingMode,DialingMode),
         LevelChanged = @LevelChanged,
         Notes = @Notes,
         RuleId = @RuleId,
         ExtRuleId = @ExtRuleId,
         NextCallBack = @NextCBKDate
  WHERE  hisrespondent = @HisRespondent
         AND hiscallnumber = @HisCallNumber
         
  IF @@ROWCOUNT = 0
    BEGIN
      INSERT INTO historic
                 (hisrespondent,
                  hiscallnumber,
                  hisinterviewer,
                  hisresult,
                  hiscalldate,
                  histimeslot,
                  hiscallduration,
                  hisdatatype,
                  hisstartquestion,
                  hisendquestion,
                  hismonitoring,
                  hisdialerline,
                  hiswait,
                  hispause,
                  hisfilereference,
                  hispreviouscalldate,
                  hislifestate,
                  projectid,
                  collectmode,
                  HisPhone,
                  DialingMode,
                  LevelChanged,
                  Notes,
                  RuleId,
                  ExtRuleId,
                  NextCallBack)
      VALUES     (@HisRespondent,
                  @HisCallNumber,
                  @HisInterviewer,
                  @HisResult,
                  @HisCallDate,
                  @HisTimeSlot,
                  @HisCallDuration,
                  @HisDataType,
                  @HisStartQuestion,
                  @HisEndQuestion,
                  @HisMonitoring,
                  @HisDialerLine,
                  @HisWait,
                  @HisPause,
                  @HisFileReference,
                  @HisPreviousCallDate,
                  @HisLifeState,
                  @projectId,
                  @collectMode, 
                  @HisPhone,
                  IsNull(@DialingMode,0),
                  @LevelChanged,
                  @Notes,
                  @RuleId,
                  @ExtRuleId,
                  @NextCBKDate)
    END
GO




-- =============================================
-- RK: New Rules & ExtendedRules business layer stored procedures
-- April 2012 
-- =============================================

/****** Object:  StoredProcedure [dbo].[sp_GetExtendedRules]    Script Date: 04/06/2012 13:14:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[vx_sp_GetCallBackExtendedRules]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[VX_sp_GetCallBackExtendedRules]
GO


CREATE PROCEDURE [dbo].[VX_sp_GetCallBackExtendedRules]
	@ReturnDeleted bit= 0
AS
BEGIN
	SET NOCOUNT ON;
	
	SELECT ExtNumber, ExtNewResult, ExtLifeState, ExtResultsSequence, ExtCallback,
		IsNull(ExtInterviewer,'') as ExtInterviewer, ExtDelay, ExtUnit, ExtPriority, ExtPriorityType, IsNull(DialingMode,'-1') as DialingMode, ExtWaveInc,projectId,modifiedBy,modified, SynchResult,Id,deleted
	FROM  ExtendedRules
	WHERE deleted = 0 or deleted = @ReturnDeleted
	ORDER BY ExtNumber
END

GO





/****** Object:  StoredProcedure [dbo].[sp_GetExtendedRulesById]    Script Date: 04/06/2012 13:17:15 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[vx_sp_GetCallBackExtendedRulesById]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[VX_sp_GetCallBackExtendedRulesById]
GO

CREATE PROCEDURE [dbo].[VX_sp_GetCallBackExtendedRulesById]
	@Id int
AS
BEGIN
	SET NOCOUNT ON;
	
	SELECT ExtNumber, ExtNewResult, ExtLifeState, ExtResultsSequence, ExtCallback,
		IsNull(ExtInterviewer,'') as ExtInterviewer, ExtDelay, ExtUnit, ExtPriority, ExtPriorityType, IsNull(DialingMode,'-1') as DialingMode, ExtWaveInc,projectId,modifiedBy,modified, SynchResult,Id,deleted
	FROM  ExtendedRules
	WHERE Id = @Id and deleted = 0 
	ORDER BY ExtNumber
END
GO




/****** Object:  StoredProcedure [dbo].[sp_GetRules]    Script Date: 04/06/2012 13:18:09 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[vx_sp_GetCallBackRules]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[VX_sp_GetCallBackRules]
GO


CREATE PROCEDURE [dbo].[VX_sp_GetCallBackRules]
	@ReturnDeleted bit= 0 
AS
BEGIN		
	SET NOCOUNT ON;
	
	SELECT RulNumber, RulResult, RulCount, RulConsecutive, RulCallback,IsNull(RulInterviewer,'') as RulInterviewer, RulDelay, RulUnit, RulPriority, RulPriorityType, 
		IsNull(DialingMode,'-1') as DialingMode, RulWaveInc,projectId,modifiedBy,modified, SynchResult,Id, deleted
	FROM  Rules 
	WHERE deleted = 0 or deleted = @ReturnDeleted
	ORDER BY rulresult,rulcount
END

GO




/****** Object:  StoredProcedure [dbo].[sp_GetRulesById]    Script Date: 04/06/2012 13:19:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[vx_sp_GetCallBackRulesById]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[VX_sp_GetCallBackRulesById]
GO

CREATE PROCEDURE [dbo].[VX_sp_GetCallBackRulesById]
	@Id int
AS
BEGIN
	SET NOCOUNT ON;

	SELECT RulNumber, RulResult, RulCount, RulConsecutive, RulCallback,IsNull(RulInterviewer,'') as RulInterviewer, RulDelay, RulUnit, RulPriority, RulPriorityType, 
		IsNull(DialingMode,'-1') as DialingMode, RulWaveInc,projectId,modifiedBy,modified, SynchResult,Id, deleted
	FROM Rules 
	WHERE Id = @Id and deleted = 0
	ORDER BY rulresult,rulcount
END
GO




/****** Object:  StoredProcedure [dbo].[sp_UpdateRules]    Script Date: 04/10/2012 10:52:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[vx_sp_UpdateCallBackRules]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[VX_sp_UpdateCallBackRules]
GO

/****** Object:  StoredProcedure [dbo].[vx_sp_UpdateCallBackRules]    Script Date: 05/30/2012 13:57:17 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[VX_sp_UpdateCallBackRules]
 @NewRules xml
AS
BEGIN
 SET NOCOUNT ON;
SELECT
   colx.value('Id[1]','int') as Id 
  ,colx.value('RulNumber[1]','int') as RulNumber
  ,colx.value('RulResult[1]','varchar(2)') as RulResult
  ,colx.value('RulCount[1]','int') as RulCount
  ,colx.value('RulConsecutive[1]','bit') as RulConsecutive
  ,colx.value('RulCallback[1]','bit') as RulCallback
  ,colx.value('RulInterviewer[1]','varchar(10)') as RulInterviewer
  ,colx.value('RulDelay[1]','int') as RulDelay
  ,colx.value('RulUnit[1]','int') as RulUnit
  ,colx.value('RulPriority[1]','int') as RulPriority
  ,colx.value('RulPriorityType[1]','int') as RulPriorityType
  ,colx.value('RulWaveInc[1]','bit')as RulWaveInc
  ,colx.value('projectId[1]','int') as projectid
  ,colx.value('modifiedBy[1]','int') as modifiedBy
  ,colx.value('xs:dateTime(modified[1])','datetime') as modified
  ,colx.value('SynchResult[1]','int') as SynchResult
  ,colx.value('DialingMode[1]','int') as DialingMode
 INTO #TMP FROM @NewRules.nodes('NewDataSet/CallBackRule') AS Tabx(Colx)
 update Rules 
 set deleted = 1 
 from (
  select Id,RulResult,RulCount,RulConsecutive,RulCallback,
   isnull(RulInterviewer,'') as RulInterviewer,RulDelay,RulUnit,RulPriority,RulPriorityType,RulWaveInc,projectId,SynchResult,DialingMode
  from Rules where deleted = 0
  except
  select Id,RulResult,RulCount,RulConsecutive,RulCallback,
   isnull(RulInterviewer,'') as RulInterviewer,RulDelay,RulUnit,nullif(RulPriority,0) as RulPriority,nullif(RulPriorityType,0) as RulPriorityType,RulWaveInc,projectId,SynchResult,DialingMode
  from #TMP 
  )b
 where deleted = 0  and Rules.Id = b.Id
 
  update rules set rules.modifiedBy = #TMP.modifiedBy ,rules.modified = #TMP.modified from #TMP
  where rules.deleted = 1 and #TMP.Id = rules.Id	 
  
   
 insert into Rules (RulNumber,RulResult,RulCount,RulConsecutive,RulCallback,
  RulInterviewer,RulDelay,RulUnit,RulPriority,RulPriorityType,RulWaveInc,projectId,modifiedBy,modified,SynchResult,DialingMode)
   select #TMP.RulNumber,#TMP.RulResult,#TMP.RulCount,#TMP.RulConsecutive,#TMP.RulCallback,
  isnull(#TMP.RulInterviewer,'') as RulInterviewer,#TMP.RulDelay,#TMP.RulUnit,#TMP.RulPriority,#TMP.RulPriorityType,#TMP.RulWaveInc,#TMP.projectId,#TMP.modifiedBy,#TMP.modified,#TMP.SynchResult,#TMP.DialingMode
 from #TMP 
  join (
  select RulResult,RulCount,RulConsecutive,RulCallback,
   isnull(RulInterviewer,'') as RulInterviewer,RulDelay,RulUnit,nullif(RulPriority,0) as RulPriority,nullif(RulPriorityType,0) as RulPriorityType,RulWaveInc,projectId,SynchResult,DialingMode
  from #TMP 
  except
  select RulResult,RulCount,RulConsecutive,RulCallback,
   isnull(RulInterviewer,'') as RulInterviewer,RulDelay,RulUnit,RulPriority,RulPriorityType,RulWaveInc,projectId,SynchResult,DialingMode
  from Rules where deleted = 0) b  
   on #TMP.RulResult = b.RulResult and #TMP.RulCount = b.RulCount and #TMP.RulConsecutive = b.RulConsecutive and #TMP.RulCallback = b.RulCallback
   and isnull(#TMP.RulInterviewer,'') = isnull(b.RulInterviewer,'') and #TMP.RulDelay = b.RulDelay and #TMP.RulUnit = b.RulUnit 
   and isnull(#TMP.RulPriority,0) = isnull(b.RulPriority,0) and isnull(#TMP.RulPriorityType,0) = isnull(b.RulPriorityType,0)
   and #TMP.RulWaveInc = b.RulWaveInc and #TMP.projectId = b.projectId and #TMP.SynchResult = b.SynchResult
   and isnull(#TMP.DialingMode,-1) = isnull(b.DialingMode,-1)
 DROP TABLE #TMP
END


GO






/****** Object:  StoredProcedure [dbo].[sp_UpdateExtendedRules]    Script Date: 04/11/2012 09:24:22 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[vx_sp_UpdateCallBackExtendedRules]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[VX_sp_UpdateCallBackExtendedRules]
GO

/****** Object:  StoredProcedure [dbo].[sp_UpdateCallBackExtendedRules]    Script Date: 04/11/2012 09:24:22 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE PROCEDURE [dbo].[VX_sp_UpdateCallBackExtendedRules]
@NewExtendedRules xml
AS
BEGIN
	SET NOCOUNT ON;
 
	SELECT 
		   colx.value('Id[1]','int') as Id 
		,colx.value('ExtNumber[1]','int') as ExtNumber
		,colx.value('ExtNewResult[1]','varchar(2)') as ExtNewResult
		,colx.value('ExtLifeState[1]','varchar(3900)') as ExtLifeState
		,colx.value('ExtResultsSequence[1]','varchar(4000)')  as ExtResultsSequence
		,colx.value('ExtCallback[1]','bit') as ExtCallback
		,colx.value('ExtInterviewer[1]','varchar(10)')      as ExtInterviewer
		,colx.value('ExtDelay[1]','int') as ExtDelay
		,colx.value('ExtUnit[1]','int') as ExtUnit
		,colx.value('ExtPriority[1]','int') as ExtPriority
		,colx.value('ExtPriorityType[1]','int') as ExtPriorityType
		,colx.value('DialingMode[1]','int') as DialingMode
		,colx.value('ExtWaveInc[1]','bit') as ExtWaveInc
		,colx.value('projectId[1]','int') as projectid
		,colx.value('modifiedBy[1]','int') as modifiedBy
		,colx.value('xs:dateTime(modified[1])','datetime') as modified    
		,colx.value('SynchResult[1]','int') as SynchResult    
		--,colx.value('RestrictionOverride[1]','bit') as RestrictionOverride
	INTo #TMP FROM @NewExtendedRules.nodes('NewDataSet/ExtendedRules') AS Tabx(Colx)


	update ExtendedRules set deleted = 1 
	from (
	select 
	Id,ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,ExtInterviewer,ExtDelay
	,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,SynchResult,DialingMode
	from ExtendedRules where deleted = 0
	except
	select Id,ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,ExtInterviewer,ExtDelay
	,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,SynchResult,DialingMode
	from #TMP 
	)b
	where deleted = 0  and ExtendedRules.Id = b.Id

 	   update ExtendedRules set ExtendedRules.modifiedBy = #TMP.modifiedBy ,ExtendedRules.modified = #TMP.modified from #TMP
	  where ExtendedRules.deleted = 1 and #TMP.Id = ExtendedRules.Id 

	insert into ExtendedRules
	(ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,ExtInterviewer,ExtDelay
	,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,projectId,modifiedBy,modified,SynchResult,DialingMode)

	select ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,isnull(ExtInterviewer,'') as ExtInterviewer,ExtDelay
	,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,projectId,modifiedBy,modified,SynchResult,DialingMode
	from #TMP where ExtNumber in (
	select ExtNumber from 
	(
	select ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,ExtInterviewer,ExtDelay
	,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,SynchResult,DialingMode
	from #TMP 
	except
	select 
	ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,ExtInterviewer,ExtDelay
	,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,SynchResult,DialingMode
	from ExtendedRules  where deleted = 0
	)b)

	DROP TABLE #TMP
END
GO

-- =============================================
-- RK: End of New Rules & ExtendedRules business layer stored procedures
-- April 2012 
-- =============================================

